const { PrismaClient } = require('@prisma/client');
const prisma = new PrismaClient();

const HistoriaFedateadaController = {
  async createHistoria(req, res) {
    try {
      const { Name, LastName, ClinicHistory, Document, 
        DocumentPath, BirthDate, UsuarioId } = req.body;
      const historia = await prisma.historiaFedateada.create(
        {
          data: { Name, LastName, ClinicHistory, Document, 
            DocumentPath, BirthDate, UsuarioId }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Historia creada correctamente',
          data: historia
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Historia',
          err: error
        }
      );
    }
  },

  async getAllHistorias(req, res) {
    try {
      const historias = await prisma.historiaFedateada.findMany();
      if (historias.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de Historias',
            data: historias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Historias registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Historias',
          err: error
        }
      );
    }
  },

  async getHistoriaById(req, res) {
    try {
      const { id } = req.params;
      const historia = await prisma.historiaFedateada.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (historia !== null) {
        res.json(
          {
            status: 'success',
            msj: 'Historia encontrada',
            data: historia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Historia con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Historia',
          err: error
        }
      );
    }
  },

  async getHistoriaByNumero(req, res) {
    try {
      const { codigo } = req.params;
      const historia = await prisma.historiaFedateada.findUnique(
        {
          where: {
            ClinicHistory: parseInt(codigo)
          }
        }
      );
      if (historia !== null) {
        res.json(
          {
            status: 'success',
            msj: 'Historia encontrada',
            data: historia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Historia con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Historia',
          err: error
        }
      );
    }
  },

  async updateHistoria(req, res) {
    try {
      const { id } = req.params;
      const { Name, LastName, ClinicHistory, Document, 
        DocumentPath, BirthDate, UsuarioId } = req.body;
      const historia = await prisma.historiaFedateada.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Name, LastName, ClinicHistory, Document, 
            DocumentPath, BirthDate, UsuarioId }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Historia actualizada correctamente',
          data: historia
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Historia',
          err: error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Historia
  // async deleteHistoria(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.historiaFedateada.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'warning',
  //         msj: 'Historia eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Historia',
  //         err: error
  //       }
  //     );
  //   }
  // }
}

module.exports = HistoriaFedateadaController;
