const bcrypt = require('bcrypt');
const { PrismaClient } = require('@prisma/client');
const prisma = new PrismaClient();
// import {
//     PrismaClient
// } from '@prisma/client';
const habilitados = [
    { Name: 'desactivado' },
    { Name: 'activado' }
]
const estados = [
    { Name: 'normal' },
    { Name: 'de baja' }
]
const roles = [
    {
        Name: 'administrador',
        Functions: 'Acceso a todas las funciones y auditorias'
    },
    {
        Name: 'mensajeador',
        Functions: 'Acceso a envio de mensajes, seguimiento de mensajes'
    },
    {
        Name: 'historiador',
        Functions: 'Acceso a registrar historias depuradas e incautadas y al movimiento de historias'
    },
    {
        Name: 'jefatura',
        Functions: 'Acceso a dar visto bueno a los roles de su unidad organica a la que pertenece, firmas digitales de documentos'
    },
    {
        Name: 'secretaria',
        Functions: 'Acceso a subir roles de la unidad organica a la que pertenece'
    },
    {
        Name: 'fedatario',
        Functions: 'Acceso a registrar historias fedateadas y su registro fedatario'
    },
    {
        Name: 'mesadepartes',
        Functions: 'Acceso a registrar historias fedateadas y su registro fedatario'
    },
    {
        Name: 'responsable-fuas',
        Functions: 'Acceso a registrar las FUAS'
    },
]
const unidadesorganicas = [
    {
        Name: 'OFICINA DE ESTADISTICA E INFORMATICA'
    },
    {
        Name: 'DEPARTAMENTO DE CONSULTA EXTERNA'
    },
    // {
    //     Name: 'ARCHIVO CENTRAL'
    // },
    // {
    //     Name: 'AREA DE ALMACEN ESPECIALIZADO'
    // },
    // {
    //     Name: 'AREA DE BANCO DE SANGRE'
    // },
    // {
    //     Name: 'AREA DE CONTROL DE ASISTENCIA Y PERMANENCIA'
    // },
    // {
    //     Name: 'AREA DE GESTION DE SUMINISTRO E INFORMACION'
    // },
    // {
    //     Name: 'AREA DE LA PLATAFORMA DE ATENCION AL USUARIO'
    // },
    // {
    //     Name: 'AREA DE NEONATOLOGIA EN ATENCION INMEDIATA'
    // },
    // {
    //     Name: 'AREA DE REGISTRO Y LEGAJOS'
    // },
    // {
    //     Name: 'AREA DIFERNCIADO DE COVID-19'
    // },
    // {
    //     Name: 'COMISION ASCENSO'
    // },
    // {
    //     Name: 'COMISION CAS'
    // },
    // {
    //     Name: 'COMISION DE NOMBRAMIENTO HRDMIEC'
    // },
    // {
    //     Name: 'COMITE DE SELECCION'
    // },
    // {
    //     Name: 'COORD. ESTRATEGIA SANITARIA DE SALUD SEXUAL Y REPRODUCTIVA'
    // },
    // {
    //     Name: 'COORDINACION DE ENFERMEDADES NO TRANSMISIBLES'
    // },
    // {
    //     Name: 'COORDINACION DE ESNITS-VIH/SIDA-HB'
    // },
    // {
    //     Name: 'COORDINACION DE EVAJ.'
    // },
    // {
    //     Name: 'COORDINACION DE PROGRAMA DE DISCAPACIDAD'
    // },
    // {
    //     Name: 'COORDINACION DE PROGRAMA DE PREVENCION Y CONTROL DE CANCER'
    // },
    // {
    //     Name: 'DEPARTAMENTO DE ANESTESIOLOGIA Y CENTRO QUIRURGICO'
    // },
    // {
    //     Name: 'DEPARTAMENTO DE APOYO AL TRATAMIENTO'
    // },
    // {
    //     Name: 'DEPARTAMENTO DE AYUDA AL DIAGNOSTICO'
    // },
    // {
    //     Name: 'DEPARTAMENTO DE EMERGENCIA Y CUIDADOS CRITICOS'
    // },
    // {
    //     Name: 'DEPARTAMENTO DE ENFERMERIA'
    // },
    // {
    //     Name: 'DEPARTAMENTO DE ESPECIALIDADES MEDICAS'
    // },
    // {
    //     Name: 'DEPARTAMENTO DE GINECO-OBSTETRICIA'
    // },
    // {
    //     Name: 'DEPARTAMENTO DE MEDICINA FISICA Y REHABILITACI&Oacute;N'
    // },
    // {
    //     Name: 'DEPARTAMENTO DE ODONTOESTOMATOLOGIA'
    // },
    // {
    //     Name: 'DEPARTAMENTO DE PEDIATRIA'
    // },
    // {
    //     Name: 'DIRECCION ADJUNTA'
    // },
    // {
    //     Name: 'DIRECCION GENERAL'
    // },
    // {
    //     Name: 'LIBRO DE RECLAMACIONES'
    // },
    // {
    //     Name: 'MESA DE PARTES'
    // },
    // {
    //     Name: 'OFICINA DE APOYO A LA DOCENCIA E INVESTIGACION'
    // },
    // {
    //     Name: 'OFICINA DE ASESORIA JURIDICA'
    // },
    // {
    //     Name: 'OFICINA DE COMUNICACIONES'
    // },
    // {
    //     Name: 'OFICINA DE CONTROL INTERNO'
    // },
    // {
    //     Name: 'OFICINA DE ECONOMIA'
    // },
    // {
    //     Name: 'OFICINA DE EPIDEMIOLOGIA Y SALUD AMBIENTAL'
    // },
    // {
    //     Name: 'OFICINA DE GESTION DE LA CALIDAD'
    // },
    // {
    //     Name: 'OFICINA DE LOGISTICA'
    // },
    // {
    //     Name: 'OFICINA DE RECURSOS HUMANOS'
    // },
    // {
    //     Name: 'OFICINA DE SALUD DE LAS PERSONAS'
    // },
    // {
    //     Name: 'OFICINA DE SEGUROS PUBLICOS Y PRIVADOS'
    // },
    // {
    //     Name: 'OFICINA DE SERVICIOS GENERALES Y MANTENIMIENTO'
    // },
    // {
    //     Name: 'OFICINA EJECUTIVA DE ADMINISTRACION'
    // },
    // {
    //     Name: 'OFICINA EJECUTIVA DE PLANEAMIENTO ESTRATEGICO'
    // },
    // {
    //     Name: '&Oacute;RGANO DE CONTROL INSTITUCIONAL'
    // },
    // {
    //     Name: 'SECRETARIA TECNICA DE PROCEDIMIENTO ADMINISTRATIVO DISCIPLINARIO'
    // },
    // {
    //     Name: 'SERVICIO DE DIAGNOSTICO POR IMAGENES'
    // },
    // {
    //     Name: 'SERVICIO DE EMERGENCIA'
    // },
    // {
    //     Name: 'SERVICIO DE ENFERMERIA CONSULTORIOS EXTERNOS'
    // },
    // {
    //     Name: 'SERVICIO DE ENFERMERIA EN CENTRO QUIRURGICO'
    // },
    // {
    //     Name: 'SERVICIO DE ENFERMERIA EN CUIDADOS INTENSIVOS'
    // },
    // {
    //     Name: 'SERVICIO DE ENFERMERIA EN EMERGENCIA'
    // },
    // {
    //     Name: 'SERVICIO DE ENFERMERIA EN ESTRATEGIAS SANITARIAS'
    // },
    // {
    //     Name: 'SERVICIO DE ENFERMERIA EN GINECOLOGIA'
    // },
    // {
    //     Name: 'SERVICIO DE ENFERMERIA EN NEONATOLOGIA'
    // },
    // {
    //     Name: 'SERVICIO DE ENFERMERIA EN PEDIATRIA'
    // },
    // {
    //     Name: 'SERVICIO DE FARMACIA'
    // },
    // {
    //     Name: 'SERVICIO DE NUTRICI&Oacute;N Y DIETETICA'
    // },
    // {
    //     Name: 'SERVICIO DE OBSTETRAS'
    // },
    // {
    //     Name: 'SERVICIO DE PATOLOGIA CLINICA Y ANATOMIA PATOLOGICA'
    // },
    // {
    //     Name: 'SERVICIO DE PSICOLOGIA'
    // },
    // {
    //     Name: 'SERVICIO DE SALUD OCUPACIONAL'
    // },
    // {
    //     Name: 'SERVICIO DE TRABAJO SOCIAL'
    // },
    // {
    //     Name: 'SERVICIOS DE SALUD'
    // },
    // {
    //     Name: 'UNIDAD COSTOS E INVERSION'
    // },
    // {
    //     Name: 'UNIDAD DE ADMISION'
    // },
    // {
    //     Name: 'UNIDAD DE ADQUISICIONES'
    // },
    // {
    //     Name: 'UNIDAD DE ALMACEN'
    // },
    // {
    //     Name: 'UNIDAD DE BIENESTAR DE PERSONAL'
    // },
    // {
    //     Name: 'UNIDAD DE CAPACITACION'
    // },
    // {
    //     Name: 'UNIDAD DE CONTROL PATRIMONIAL'
    // },
    // {
    //     Name: 'UNIDAD DE CONTROL PREVIO'
    // },
    // {
    //     Name: 'UNIDAD DE EJECUCION PRESUPUESTAL'
    // },
    // {
    //     Name: 'UNIDAD DE GESTION DE RIESGOS DE DESASTRES Y DEFENSA NACIONAL'
    // },
    // {
    //     Name: 'UNIDAD DE INFORMATICA Y TELECOMUNICACION'
    // },
    // {
    //     Name: 'UNIDAD DE INTEGRACION CONTABLE'
    // },
    // {
    //     Name: 'UNIDAD DE PLANEAMIENTO Y GESTION INSTITUCIONAL'
    // },
    // {
    //     Name: 'UNIDAD DE PLANIFICACION DE RECURSOS HUMANOS'
    // },
    // {
    //     Name: 'UNIDAD DE PRESUPUESTO'
    // },
    // {
    //     Name: 'UNIDAD DE PROCESOS DE SELECCION'
    // },
    // {
    //     Name: 'UNIDAD DE PROGRAMACION E INFORMACION'
    // },
    // {
    //     Name: 'UNIDAD DE RACIONALIZACI&Oacute;N'
    // },
    // {
    //     Name: 'UNIDAD DE REMUNERACIONES'
    // },
    // {
    //     Name: 'UNIDAD DE SEGURIDAD DEL PACIENTE'
    // },
    // {
    //     Name: 'UNIDAD DE TESORERIA'
    // },
    // {
    //     Name: 'UNIDAD DE TRIBUTACION'
    // },
    // {
    //     Name: 'UNIDAD SELECCION DE PERSONAL'
    // },
    // {
    //     Name: 'UNIDADES DE PENSIONES Y OTROS BENEFICIOS'
    // }
]

const usuarios = [
    {
        Name: "Anibal Jhamil",
        LastName: "Huaman Verastein",
        Phone: "958899251",
        Email: "anibaljhamil@gmail.com",
        Password: '123',
        Photo: "https://res.cloudinary.com/jx-design/image/upload/v1605019616/Foto/gcuwyoeffnb4rot3ldg0.png",
        Code: '9999999999',
        RolId: 1,
        EnabledId: 1,
        StateId: 1,
        UnidadOrganicaId: 1
    },
    // {
    //     Name: "Nicol Maryori",
    //     LastName: "Hospina Ramos",
    //     Phone: "968044470",
    //     Email: "76620571@sam.edu.pe",
    //     Password: '123',
    //     Photo: "http://res.cloudinary.com/jx-design/image/upload/v1689895895/Foto/ow6bxaagnwdxap8kutkj.png",
    //     Code: '9999999999',
    //     RolId: 1,
    //     EnabledId: 1,
    //     StateId: 1,
    //     UnidadOrganicaId: 1
    // },
    // {
    //     Name: "Anali Nelia",
    //     LastName: "Sedano Gomes",
    //     Phone: "987128204",
    //     Email: "analisesanogomezq@gmail.com",
    //     Password: '123',
    //     Photo: "http://res.cloudinary.com/jx-design/image/upload/v1689895981/Foto/zhfqivb8nqctzy8dyghv.png",
    //     Code: '9999999999',
    //     RolId: 1,
    //     EnabledId: 1,
    //     StateId: 1,
    //     UnidadOrganicaId: 1
    // },
    // {
    //     Name: "Nayla Lea",
    //     LastName: "De la Rosa Malpica",
    //     Phone: "915952421",
    //     Email: "nyaladelarosa0@gmail.com",
    //     Password: '123',
    //     Photo: "http://res.cloudinary.com/jx-design/image/upload/v1689896051/Foto/l7geyhx3svbdkkb0mjjy.png",
    //     Code: '9999999999',
    //     RolId: 1,
    //     EnabledId: 1,
    //     StateId: 1,
    //     UnidadOrganicaId: 1
    // },
    // {
    //     Name: "Aurea Casilda",
    //     LastName: "Olivera Dionisio",
    //     Phone: "964749096",
    //     Email: "cureolivera17@gmail.com",
    //     Password: '123',
    //     Photo: "http://res.cloudinary.com/jx-design/image/upload/v1689896134/Foto/n8lsgzxypjhhe6hmqscn.png",
    //     Code: '9999999999',
    //     RolId: 1,
    //     EnabledId: 1,
    //     StateId: 1,
    //     UnidadOrganicaId: 1
    // },
    // {
    //     Name: "July Sarai",
    //     LastName: "Villazana Huaman",
    //     Phone: "957900551",
    //     Email: "villazanahuamansarai@gmail.com",
    //     Password: '123',
    //     Photo: "http://res.cloudinary.com/jx-design/image/upload/v1689896214/Foto/wybzucwqqmbpdcgs9bym.png",
    //     Code: '9999999999',
    //     RolId: 1,
    //     EnabledId: 1,
    //     StateId: 1,
    //     UnidadOrganicaId: 1
    // },
    // {
    //     Name: "Sadith Delcy",
    //     LastName: "Janampa Julcapari",
    //     Phone: "964749095",
    //     Email: "delcyjulcapari@gmail.com",
    //     Password: '123',
    //     Photo: "http://res.cloudinary.com/jx-design/image/upload/v1689896313/Foto/ckvb21t6qzeifz3y05qu.png",
    //     Code: '9999999999',
    //     RolId: 1,
    //     EnabledId: 1,
    //     StateId: 1,
    //     UnidadOrganicaId: 1
    // },
    {
        Name: "Jose Darwin",
        LastName: "Valerio Aldana",
        Phone: "971042356",
        Email: "valerio121@gmail.com",
        Password: '123',
        Photo: "http://res.cloudinary.com/jx-design/image/upload/v1692390158/Foto/htunfdrzlpbuhuslznpb.png",
        Code: '9999999999',
        RolId: 1,
        EnabledId: 1,
        StateId: 1,
        UnidadOrganicaId: 1
    },
    {
        Name: "Natali Deysi",
        LastName: "Medina Sanabria",
        Phone: "941415929",
        Email: "natushams@gmail.com",
        Password: '123',
        Photo: "",
        Code: '9999999999',
        RolId: 2,
        EnabledId: 1,
        StateId: 1,
        UnidadOrganicaId: 2
    },
    {
        Name: "Golda Violeta",
        LastName: "Guerra Poma",
        Phone: "985734444",
        Email: "goldavioletaguerrapoma@gmail.com",
        Password: '123',
        Photo: "",
        Code: '9999999999',
        RolId: 2,
        EnabledId: 1,
        StateId: 1,
        UnidadOrganicaId: 2
    },
    {
        Name: "Chris Madeleine",
        LastName: "Ñahupari Arenales",
        Phone: "935600764",
        Email: "chrismadeleinearenales@gmail.com",
        Password: '123',
        Photo: "",
        Code: '9999999999',
        RolId: 2,
        EnabledId: 1,
        StateId: 1,
        UnidadOrganicaId: 2
    },
    {
        Name: "Roxana",
        LastName: "Parimango Carhuas",
        Phone: "953985953",
        Email: "roxanaparimango234728@gmail.com",
        Password: '123',
        Photo: "",
        Code: '9999999999',
        RolId: 2,
        EnabledId: 1,
        StateId: 1,
        UnidadOrganicaId: 2
    },
    // {
    //     Name: "Sheyla",
    //     LastName: "Damas Castro",
    //     Phone: "924131068",
    //     Email: "sheyla@gmail.com",
    //     Password: '123',
    //     Photo: "http://res.cloudinary.com/jx-design/image/upload/v1692390158/Foto/htunfdrzlpbuhuslznpb.png",
    //     Code: '9999999999',
    //     RolId: 1,
    //     EnabledId: 1,
    //     StateId: 1,
    //     UnidadOrganicaId: 1
    // }
]


async function seed() {
    console.log('Iniciando la insercion de datos en las tablas');
    console.log('-----------------------------');
    console.log('------------habilitados-----------');
    for (const datahabilitado of habilitados) {
        await prisma.enabled.create({data: datahabilitado});
    }
    console.log('------------estados-----------');
    for (const dataestado of estados) {
        await prisma.state.create({data: dataestado});
    }
    console.log('------------roles-----------');
    for (const datarol of roles) {
        await prisma.rol.create({data: datarol});
        console.log(`Se ha creado el rol: ${datarol.Name}`);
    }
    console.log('------------unidades organicas-----------');
    for (const dataunidadorganica of unidadesorganicas) {
        await prisma.unidadOrganica.create({data: dataunidadorganica});
        console.log(`Se ha creado una nueva unidad organica: ${dataunidadorganica.Name}`);
    }
    console.log('------------usuario-----------');
    for (const datausuario of usuarios) {
        let lacontra = await bcrypt.hash(datausuario.Password, 10);
        datausuario.Password = lacontra;
        await prisma.usuario.create({data: datausuario});
        console.log(`Se ha creado un nuevo usuario: ${datausuario.Name}`);
    }
    console.log('-----------------------------');
    console.log('Insercion de tablas finalizado');
    // );
}

seed()
    .catch(
        (e) => {
            console.error(e)
            process.exit(1)
        }
    )
    .finally(
        async () => {
            await prisma.$disconnect()
        }
    )