const express = require('express');
const router = express.Router();
const FirmaDigitalController = require('../controllers/firmadigital.controller');

// GET all FirmaDigitals
router.get('/', FirmaDigitalController.getAllFirmaDigitals);

// GET FirmaDigital by id
router.get('/:id', FirmaDigitalController.getFirmaDigitalById);

// POST a new FirmaDigital
router.post('/', FirmaDigitalController.createFirmaDigital);

// PUT update an existing FirmaDigital
router.put('/update/:id', FirmaDigitalController.updateFirmaDigital);

// DELETE an existing FirmaDigital
// muy probable no considerar esta opción
// router.delete('/:id', FirmaDigitalController.deleteFirmaDigital);

// para los filtros de FirmaDigital por usuario
router.get('/usuario/:codigo', FirmaDigitalController.getFirmaDigitalByUsuario);

module.exports = router;
