const express = require('express');
const router = express.Router();
const HorarioController = require('../controllers/horario.controller');

// GET all Horarios
router.get('/', HorarioController.getAllHorarios);

// GET Horario by id
router.get('/:id', HorarioController.getHorarioById);

// POST a new Horario
router.post('/', HorarioController.createHorario);

// PUT update an existing Horario
router.put('/:id', HorarioController.updateHorario);

// DELETE an existing Horario
// muy probable no considerar esta opción
// router.delete('/:id', HorarioController.deleteHorario);

// para los filtros de Horario por usuario
router.get('/usuario/:codigo', HorarioController.getHorarioByUsuario);

// para los filtros de Horario por unidad organizativa
router.get('/unidadorganica/:codigo', HorarioController.getHorarioByUnidadOrganica);

// para los filtros de Horario por periodo de entrega
router.get('/periodo/:anio/:mes', HorarioController.getHorarioByUnidadOrganica);

module.exports = router;
